﻿//////////////////////////////////////////////
// JpgConstants.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Class ------------------------------------

namespace nkImages::jpg
{
	class JpgConstants
	{
		public :

			// Supported and inspected marker patterns
			// Prefix for marker, and its fill if not a marker
			static constexpr unsigned char MARKER_PREFIX = 0xFF ;
			static constexpr unsigned char MARKER_FILL = 0x00 ;

			// Start and End Of Image
			static constexpr unsigned char MARKER_SOI = 0xD8 ;
			static constexpr unsigned char MARKER_EOI = 0xD9 ;

			// Quantization Tables
			static constexpr unsigned char MARKER_DQT = 0xDB ;

			// Huffman tales
			static constexpr unsigned char MARKER_DHT = 0xC4 ;

			// Frame info
			static constexpr unsigned char MARKER_SOF_BASELINE = 0xC0 ;
			static constexpr unsigned char MARKER_SOF_PROGRESSIVE = 0xC2 ;
			static constexpr unsigned char MARKER_SOS = 0xDA ;

			// Comment section
			static constexpr unsigned char MARKER_COMMENT = 0xFE ;

			// Restart
			static constexpr unsigned char MARKER_RESTART_INTERVAL = 0xDD ;

			// Apps
			static constexpr unsigned char MARKER_APP0 = 0xE0 ;
			static constexpr unsigned char MARKER_APP1 = 0xE1 ;
			static constexpr unsigned char MARKER_APP13 = 0xED ;

		public :

			// LUT for de zig zag
			static constexpr unsigned int ZIGZAG_LUT [64] =
			{
				0, 
				1, 8,
				16, 9, 2,
				3, 10, 17, 24,
				32, 25, 18, 11, 4,
				5, 12, 19, 26, 33, 40,
				48, 41, 34, 27, 20, 13, 6,
				7, 14, 21, 28, 35, 42, 49, 56,
				57, 50, 43, 36, 29, 22, 15,
				23, 30, 37, 44, 51, 58,
				59, 52, 45, 38, 31,
				39, 46, 53, 60,
				61, 54, 47,
				55, 62,
				63
			} ;
	} ;
}